<?xml version="1.0" encoding="UTF-8"?>
<template expand_clusters="true" version="2">
    <!-- Basic system utilization stuff -->
    <chart title="CPU Activity" series_composition="stacked" rendering_type="bar" average_selection="yes" average_cores="yes" percentage="yes">
        <series name="User" expression="$CPUActivityUser" description="Linux User activity" display="AVERAGE" color="58,223,67"/>
        <series name="System" expression="$CPUActivitySystem" description="Linux System activity" display="AVERAGE" color="223,71,66"/>
    </chart>
    <chart title="Cycles" series_composition="overlay" rendering_type="line">
        <series name="CPU Cycles" expression="$CyclesCPUCycles" description="The counter increments on every cycle" display="ACCUMULATE" color="94,142,235" units="cycles"/>
        <series name="SME Cycles" expression="$CyclesSMECycles" description="Counts SME clock cycles (not timer cycles). The clock measured by this event is defined as the physical clock driving the SME logic." display="ACCUMULATE" color="87,227,137" units="cycles"/>
    </chart>

    <!-- Basic IPC stuff -->
    <chart title="IPC" series_composition="overlay" rendering_type="line" optional="yes">
        <series name="CPU IPC" expression="$InstructionsExecutedAll/$CyclesCPUCycles" description="" display="ACCUMULATE" color="53,132,228"/>
        <series name="SME IPC" expression="$InstructionsExecutedSME/$CyclesSMECycles" description="" display="ACCUMULATE" color="51,209,122"/>
    </chart>
    <chart title="SME/CPU Insn Ratio" series_composition="stacked" rendering_type="bar" optional="yes">
        <series name="CPU" expression="$InstructionsExecutedAll" description="" display="ACCUMULATE" color="53,132,228" units="insns"/>
        <series name="SME" expression="$InstructionsExecutedSME" description="" display="ACCUMULATE" color="51,209,122" units="insns"/>
    </chart>

    <!-- Stalls -->
    <chart title="CPU Backend Stall Cycles" series_composition="stacked" rendering_type="bar" percentage="yes" optional="yes">
        <series name="SME Busy" expression="min($StallsBackendSMEBusy/$CyclesCPUCycles, 1)" description="Percentage of cycles where the CPU was stalled due to SME instructions not being sent" display="ACCUMULATE" color="237,51,59" units="%"/>
    </chart>
    <chart title="CPU / SME Memory Hazards" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="CPU stalled by SME" expression="min($StallsBackendCPUStalledBySMEMemoryHazard/$CyclesCPUCycles, 1)" description="Percentage of cycles where the CPU was stalled because at least one CPU load/store instruction is waiting for resolution from an address hazard, and the CPU cannot execute the operation to preserve required ordering of memory effects. Typically indicates that the CPU and SME are making overlapping accesses, that is, both are accessing the same location" display="ACCUMULATE" color="255,163,72" units="%"/>
        <series name="SME Stalled by CPU" expression="min($StallsBackendSMEStalledByCPUMemoryHazard/$CyclesCPUCycles, 1)" description="Percentage of cycles where the CPU was stalled because at least one Streaming SVE load/store instruction is waiting for resolution from an address hazard, and the SME cannot accept the operation to preserve required ordering of memory effects. Typically indicates that the CPU and SME are making overlapping accesses, that is, both are accessing the same location" display="ACCUMULATE" color="224,27,36" units="%"/>
    </chart>
    <chart title="SME Stall Cycles" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="Frontend" expression="min($StallsSMEFrontend/$CyclesSMECycles,1)" description="Shows the percentage of SME cycles where no operations are issued while instruction queues are not full." display="ACCUMULATE" color="120,210,136" units="%"/>
        <series name="Backend" expression="min($StallsSMEBackend/$CyclesSMECycles,1)" description="Shows the percentage of SME cycles where the rename unit is unable to send any micro-operations to the SME backend of the pipeline because of backend resource constraints. Backend resource constraints can include issue stage fullness, execution stage fullness, or other internal pipeline resource fullness." display="ACCUMULATE" color="94,142,235" units="%"/>
    </chart>
    <chart title="SME Backend Stall Cycles" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="Data Processing" expression="min($StallsSMEBackendDataProcessing/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to DP issue queues not accepting instructions" display="ACCUMULATE" color="153,193,241" units="%"/>
        <series name="Memory" expression="min($StallsSMEBackendMemory/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to Load-Store issue queues not accepting instructions" display="ACCUMULATE" color="220,138,221" units="%"/>
        <series name="Prefetcher" expression="min($StallsSMEBackendPrefetcher/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to prefetcher issue queues not accepting instructions" display="ACCUMULATE" color="249,240,107" units="%"/>
    </chart>
    <chart title="SME Backend Stall Cycles (Data Processing)" series_composition="overlay" rendering_type="line" percentage="yes">
        <series name="Issue Queue DP0 Full" expression="min($StallsSMEDispatchIQFullDP0/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to the data-processing issue queue 0 being full" display="ACCUMULATE" color="249,240,107" units="%"/>
        <series name="Issue Queue DP1 Full" expression="min($StallsSMEDispatchIQFullDP1/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to the data-processing issue queue 1 being full" display="ACCUMULATE" color="255,163,72" units="%"/>
        <series name="Issue Queue LD Full" expression="min($StallsSMEDispatchIQFullLoad/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to the load issue queue being full" display="ACCUMULATE" color="224,27,36" units="%"/>
    </chart>
    <chart title="SME Backend Stall Cycles (Memory)" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="Loads" expression="min($StallsSMEBackendMemoryWaitingOnCache/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to an outstanding load that is waiting for cache arbitration" display="ACCUMULATE" color="255,163,72" units="%"/>
        <series name="Stores" expression="min($StallsSMEBackendMemoryWaitingOnStore/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to an outstanding store that is waiting the merge buffer" display="ACCUMULATE" color="224,27,36" units="%"/>
    </chart>

    <!-- Operation mix -->
    <chart title="SME Port Utilization" series_composition="stacked" rendering_type="bar">
        <series name="ALU" expression="$SMEOperationsIssuedALU/$CyclesSMECycles" description="Shows the average number of ALU operations issued per cycle" display="ACCUMULATE" color="246,211,45" />
        <series name="Divide or Square Root" expression="$SMEOperationsIssuedDivideSquareRoot/$CyclesSMECycles" description="Shows the average number of Divide/Square Root operations issued per cycle" display="ACCUMULATE" color="237,51,59" />
        <series name="Matrix Multiplication Data-processing" expression="$SMEOperationsIssuedMatrixMultiplyData/$CyclesSMECycles" description="Shows the average number of Matrix-Multiply (Data-Processing) operations issued per cycle" display="ACCUMULATE" color="145,65,172" />
        <series name="Matrix Multiplication Move" expression="$SMEOperationsIssuedMatrixMultiplyMove/$CyclesSMECycles" description="Shows the average number of Matrix-Multiply (Move) operations issued per cycle" display="ACCUMULATE" color="120,210,136" />
        <series name="Multiply-accumulate" expression="$SMEOperationsIssuedMultiplyAccumulate/$CyclesSMECycles" description="Shows the average number of Multiply-Accumulate operations issued per cycle" display="ACCUMULATE" color="98,160,234" />
        <series name="Permutation" expression="$SMEOperationsIssuedPermute/$CyclesSMECycles" description="Shows the average number of Permutation operations issued per cycle" display="ACCUMULATE" color="255,163,72" />
        <series name="Store" expression="$SMEOperationsIssuedStore/$CyclesSMECycles" description="Shows the average number of Store operations issued per cycle" display="ACCUMULATE" color="230,97,0" />
    </chart>
</template>
